/*
* Altrozero.co.uk
* Copyright of Timothy Wilson
* Contact: altrozero@gmail.com
* Information: LET IT SNOW
*/

//Config VARs
var maxFlakes2 = 350;
var flakeChar2 = "*";
var speed2 = 1.5;
var minSize2 = 7;
var maxSize2 = 8;

//Standard VARs
snowtop2 = new Array();
snowleft2 = new Array();
snowdrift2 = new Array();
snowsize2 = new Array();
snowsizechange2 = new Array();
var curLoop2 = 0;
var divName2 = "testsnowbox";
var divWidth2 = 800;
var divHeight2 = 600;

//FUNCTIONS
/*
* Make sure the div you are submitting doesn't allow overflow and is fixed size
*/
function random_num2(maxNum) {
	var rand = Math.floor(maxNum*Math.random())
    return rand
}

function start_snow2(divbox) {
	//Get div information
	divName2 = divbox;
	var stringDivWidth = document.getElementById(divName2).style.width;
	divWidth2 = stringDivWidth.slice(0, (stringDivWidth.length-2));
	var stringDivHeight = document.getElementById(divName2).style.height;
	divHeight2 = stringDivHeight.slice(0, (stringDivHeight.length-2));
	
	for(var i = 0; i < maxFlakes2; i++) {
		snowtop2[i] = random_num2(divHeight2);
		snowleft2[i] = random_num2(divWidth2);
		snowdrift2[i] = random_num2(2);
		snowsize2[i] = (random_num2((maxSize2 - minSize2)) + minSize2);
		snowsizechange2[i] = random_num2(5);
		document.getElementById(divName2).innerHTML = '<div id="snowflake2'+ i +'" style="position: absolute; color: #ffffff; font: Arial; font-size: ' + snowsize2[i] + 'px; left: ' + snowleft2[i] + 'px; top: ' + snowtop2[i] + 'px;">' + flakeChar2 + '</div>' + document.getElementById(divName2).innerHTML;
	}
	
	snow_fall2();
}

function snow_fall2() {
	for(var i = 0; i < maxFlakes2; i++) {
		//setup id
		snowflakeid = "snowflake2" + i;
		//set top location
		snowtop2[i] += speed2;
		if(snowtop2[i] + snowsize2[i] > divHeight2) {
			snowtop2[i] = 0;
			snowleft2[i] = random_num2(divWidth2);
			snowsize2[i] = (random_num2((maxSize2 - minSize2)) + minSize2);
			snowsizechange2[i] = random_num2(1);
		}
		//set left location for drift
		if(snowdrift2[i] == 1) {
			snowleft2[i] += speed2;
			if(snowleft2[i] + snowsize2[i] >= divWidth2)
				snowdrift2[i] = 2;
		} else {
			snowleft2[i] -= speed2;
			if(snowleft2[i] <= 0)
				snowdrift2[i] = 1;
		}
		//check size change
		if(snowsizechange2[i] == 1) { //getting smaller
			snowsize2[i] -= 0.1;
			if(snowsize2[i] < 0) {
				snowsize2[i] = 1;
			}
		} else if (snowsizechange2[i] == 1) { //getting bigger
			snowsize2[i] += 0.1;
		}
		
		//update page
		document.getElementById(snowflakeid).style.top = snowtop2[i] + "px";
		document.getElementById(snowflakeid).style.left = snowleft2[i] + "px";
		document.getElementById(snowflakeid).style.fontSize = snowsize2[i] + "px";
	}
	
	//restart fall
	setTimeout("snow_fall2()", 0);
}

start_snow2("testsnowbox");